//Experiment-3
// windows Vista - 32-Bit
//Scilab - 5.5.2


// Aim ; Finding voltage regulation and efficiency of a medium  transmission line using nominal T method through SCILAB

clc; 
clear all;
R=10; 
XL=20; 
Y= 4e-4; 
VRLL=66e3; 
PR=10000e3; 
pf=0.8; // change power factor of load
VR=66e3/sqrt(3);
Z=R+%i*XL;
IR=PR/(sqrt(3)*VRLL*pf);
IR_COMPLEX=IR*(cos(acos(0.8))-%i*sin(acos(0.8)));
VM=VR+IR_COMPLEX*(Z/2);
IC=%i*Y*VM;
IS=IR_COMPLEX+IC;
VS=VM+IS*(Z/2);
[VS_abs,Phase_VS]= polar(VS);
[IS_abs,Phase_IS]= polar(IS);
VS_abs;
IS_abs
VSLL=VS*sqrt(3);
VSLL_abs=abs(VSLL)/1000
PHASE_DIFF=Phase_VS-Phase_IS;
SendingEnd_PF=cos(PHASE_DIFF)
PS=3*abs(VS)*abs(IS)*cos(PHASE_DIFF);
EFF=(abs(PR)/abs(PS))*100
REG = 100*((abs (VSLL) - abs (VRLL)))/ abs (VRLL)
mprintf('Sendingend Current = %f A \n',IS_abs)
mprintf('Sendingend Line Voltage = %f kV \n',VSLL_abs)
mprintf('Sendingend Power factor = %f \n',SendingEnd_PF)
mprintf('Efficiency = %f %% \n', EFF)
mprintf('Regulation = %f %% \n', REG)


//Output:-
//
//Sendingend Current = 100.533214 A 
//Sendingend Line Voltage = 69.543925 kV 
//Sendingend Power factor = 0.853122 
//Efficiency = 96.796480 % 
//Regulation = 5.369583 % 
//
